var util = {
		doAjax : function(url,successCallback,data,sync,errorCallback,timeouter,datatype) {
			if((successCallback && typeof successCallback !== "function") || (errorCallback && typeof errorCallback !== "function") ) {
				throw new Error("ajax回调函数错误，请检查！");
			}
			var type = data ? 'post' : 'get';
			$.ajax({ 
				 type: type, 
				 contentType: "application/json;charset=utf-8",
				 timeout:timeouter||30000,
				 async: sync==="false" ? false : true,
				 url: url, 
				 data: data, 	
				 dataType: datatype||'json', 
				 success: function (json, status, xhr) {
					 util.removeMask();
					 if(successCallback) successCallback(json);
		  		 },
		  		 error : function(request) {
	  				try {
						if(request.status == 404) {
							alert("请求的服务不存在！");
						} else if(request.status == 500) {
							alert("系统内部错误，请将下面详细信息截图，联系并发送系统管理员!" + "\r\n" + request.responseText);
						} else if(request.status == 518){
							//alert("会话超时，请重新登录！");
							location.href = "/scene/login.html";
						} else if(request.status == 0) {
							alert("请求超时，服务端长时间没有响应！");
						} else if(request.status == 502){
							location.href = "/scene/login.html";
						} else {
							alert("系统发生未知错误！");
						}
						if(errorCallback) errorCallback();
					} catch (e) {
					} finally {
						util.removeMask();
					}
	  			}
			});
		},
		changeNull2Empty : function(v) {
			if(!v || typeof v === 'undefined' || v === 'null') return '';
			else return v;
		},
		trim : function(str,isGlobal) {
			if(!str) return "";
			if(isGlobal) return str.replace(/\s/g,"");
			return str.replace(/(^\s*)|(\s*$)/g, "");
		},
		getParamByName : function(paramName){
			var query = location.search.substring(1);
			var result = "";
			if(query){
				var arQuery = query.split("&");
				for(var i=0;i<arQuery.length;i++){
					var pos = arQuery[i].indexOf("=");
					var qName = arQuery[i].substring(0,pos);
					var qValue = arQuery[i].substring(pos+1);
					if(qName === paramName){
						result = qValue;
						break;
					}
				}
			}
			return result;
		},
	    jsonToString: function(obj){
	        var THIS = this;
	        switch(typeof(obj)){
	            case 'string':
	                return '"' + obj.replace(/(["\\])/g, '\\$1') + '"';
	            case 'array':
	                return '[' + obj.map(THIS.jsonToString).join(',') + ']';
	            case 'object':
	                if(obj instanceof Array){
	                    var strArr = [];
	                    var len = obj.length;
	                    for(var i=0; i<len; i++){
	                        strArr.push(THIS.jsonToString(obj[i]));
	                    }
	                    return '[' + strArr.join(',') + ']';
	                }else if(obj===null){
	                    return 'null';

	                }else{
	                    var string = [];
	                    for (var property in obj) string.push(THIS.jsonToString(property) + ':' + THIS.jsonToString(obj[property]));
	                    return '{' + string.join(',') + '}';
	                }
	            case 'number':
	                return obj;
	            case false:
	                return obj;
	        }
	    },
	    stringToJSON: function(obj){
	        obj = eval("(" + obj + ")");
	        return obj;
	    },
	    jsonFilter: function(obj_json){
	        obj_json = obj_json.replace(/\r\n|\n|\r|\t/g,'');
	        obj_json = obj_json.replace(/<\/?[^>]*>/g,'');
	        obj_json = obj_json.replace(/[ | ]*\n/g,'\n');
	        obj_json = obj_json.replace(/\n[\s| | ]*\r/g,'\n');
	        obj_json = obj_json.replace(/&nbsp;/ig,'');
	        obj_json = obj_json.replace(/&quot;/ig,'"');	
	        return obj_json;
	    },
	    inputFilter: function(str) {
	    	str = str.replace(/&/g,'&amp;');
	    	str = str.replace(/\"/gi,'&quot;');
	    	str = str.replace(/>/g,'&gt;');
	    	str = str.replace(/</g,'&lt;');	
	    	str = str.replace(/ /g,'&nbsp;');
			return str;
	    },
	    urlFilter: function(url) {
	    	url = url.replace(/%/g,'%25');
			url = url.replace(/\+/g,'%20');
	    	url = url.replace(/\//g,'%2F');
	    	url = url.replace(/\?/g,'%3F');
	    	url = url.replace(/#/g,'%23');
	    	url = url.replace(/&/g,'%26');
	    	return url;
	    },
	    setCookie:function(name,value){
	        var exp  = new Date();  
	        exp.setTime(exp.getTime() + 365*24*60*60*1000); 
	    	document.cookie = name + "="+ encodeURI (value) 
	    		+";expires=" + exp.toGMTString()+"path=/";
	    },
	    addCookie:function(name, value, minute) {
	    	var exp = new Date();
	    	exp.setTime(exp.getTime() + 1000*60*minute);
	    	document.cookie = name + "=" + encodeURI(value) + ";expires=" + exp.toGMTString() + "path=/";
	    },
	    getCookie:function(name){
			var arr,reg=new RegExp("(^| )"+name+"=([^;]*)(;|$)");
		    if(arr=document.cookie.match(reg))
		        return decodeURI(arr[2]);
		    else
		        return null;
		}, 
		delCookie : function(name) {
			var date = new Date();
			date.setTime(date.getTime() - 10000);
			document.cookie = name + "=a;path=/;expires=" + date.toGMTString();
		},
		stopEventBubble : function (event){
	        var e=event || window.event;
	        if (e && e.stopPropagation){
	            e.stopPropagation();    
	        }
	        else{
	            e.cancelBubble=true;
	        }
	    },
	    backTop : function() {
	    	$('body,html').animate({ scrollTop: 0 }, 500);
	    },
		removeMask : function() {
			//$(top.document.body).find('#loading').remove();
			$('#loading').remove();
		},
		showMask : function()  {
			var html = '<div id="loading" style="position: fixed;'
						+'background: black url(barcode/images/loading.gif) no-repeat center center;'
						+'left: 0;top: 0;width: 100%;height: 100%;opacity: 0.8;z-index: 99999;">'
						+'</div>';
			$(document.body).append($(html));//kcl 20220721
                        //$(top.document.body).append($(html));/kcl 20220721
		},
		/**限制输入为整数和小数**/
		onlyNumber : function(obj) {
			var t = obj.value.charAt(0);
			obj.value = obj.value.replace(/[^\d\.]/g, '');
			obj.value = obj.value.replace(/^\./g, '');
			obj.value = obj.value.replace(/\.{2, }/g, '.');
			obj.value = obj.value.replace('.', '$#$').replace(/\./g, '').replace('$#$', '.');
		}
};

